#include <xtl.h>
//#include <string.h>
#include <stdio.h>

extern "C"
{
	extern long WINAPI HalWriteSMBusValue(UCHAR devaddress, UCHAR offset, UCHAR readdw, BYTE data);
	extern long WINAPI HalReadSMBusValue(UCHAR devaddress, UCHAR offset, UCHAR readdw, LPBYTE pdata);
}


void pic_Eject(int v) {
	HalWriteSMBusValue(0x20, 0x0c, 0, v ? 0x00 : 0x01);
	Sleep(5);
}

void pic_ResetOnEject(int v) {
	HalWriteSMBusValue(0x20, 0x19, 0, v ? 0x00 : 0x01);
	Sleep(5);
}

void pic_PowerOff() {
	HalWriteSMBusValue(0x20, 0x02, 0, 0x80);
	for(;;); // Wait for it
}

void pic_DoReset(int hard) {
	HalWriteSMBusValue(0x20, 0x02, 0, hard ? 0x40 : 0x01);
	for(;;); // Wait for it
}

// This function will return a string containing the system temperatures
/*void gettemp(char* pltc, char*prtc) {
	if(pltc!=NULL) {
		HalReadSMBusValue(0x98, 0x00, 0, (BYTE*)pltc);
		Sleep(5);
		*pltc-=21;
	}
	if(prtc!=NULL) {
		HalReadSMBusValue(0x98, 0x01, 0, (BYTE*)prtc);
		Sleep(5);
		*prtc-=21;
	}
}*/

//This Function will Backup what we have now..
void BackupEEPROM( char *filename ) {
	byte eepromdata[256];
	ZeroMemory(eepromdata, 256);

	for (long i=0;i<256;i++) {
		HalReadSMBusValue(0xA8, (UCHAR)i, 0, &eepromdata[i]);
		Sleep(10);
	}

	//write backup to F drive...
	HANDLE file=CreateFile( filename, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL );
	DWORD written;
	WriteFile(file, eepromdata, 256, &written, NULL);
	CloseHandle(file);

}

//This Function will program the EEPROM..
void RestoreEEPROM( char *filename ) {
	byte eepromdata[256];
	ZeroMemory(eepromdata, 256);

	// Read the new EEPROM images from Disk F
	HANDLE file=CreateFile( filename, GENERIC_READ, 0, NULL, OPEN_EXISTING, 0, NULL );
	DWORD readin;
	ReadFile(file, eepromdata, 256, &readin, NULL);
	CloseHandle(file);

	//Now Program the EEPROM with the new image
	for (long i=0;i<256;i++) {
		HalWriteSMBusValue(0xA8, (UCHAR)i, 0, eepromdata[i]);
		Sleep(10);
	}
}